'use strict';

(function ($) {

  // sticky header on scroll
  $(window).scroll(function () {
    if ($(this).scrollTop() > 200) {
      $(".site-header").addClass("sticky");
    }
    else {
      $(".site-header").removeClass("sticky");
    }
  });

  /* header search input show */
  $(".header-search-login .search-icon").click(function () {
    $(".header-search-login .search-form").addClass("shown");
  });

  /* header search input hide */
  $(".header-search-login .cross-icon").click(function () {
    $(".header-search-login .search-form").removeClass("shown");
  });

  // mean menu in responsive part
  $('.menu-top-menu-container').meanmenu({
    meanMenuContainer: '.main-navigation',
    meanScreenWidth: "1199",
    meanRevealPosition: "right",
  });

  // slick slider on banner section
  $('.banner-slider-wrap').slick({
    dots: true,
    arrows: false,
    infinite: true,
    slidesToShow: 1,
    slidesToScroll: 1,
    // autoplay: true,
    // autoplaySpeed: 3000,
  });

  // slick slider on feature-insights section
  $('.feature-insights-content').slick({
    dots: false,
    arrows: true,
    infinite: true,
    slidesToShow: 3,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 993,
        settings: {
          slidesToShow: 2,
        }
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
        }
      }
    ]
  });

  // slick slider on our-team section
  $('.our-team-members').slick({
    dots: false,
    arrows: true,
    infinite: true,
    slidesToShow: 4,
    slidesToScroll: 1,
    responsive: [
      {
        breakpoint: 1024,
        settings: {
          slidesToShow: 3,
        }
      },
      {
        breakpoint: 993,
        settings: {
          slidesToShow: 2,
        }
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
        }
      }
    ]
  });

  // slick slider on flash-alerts of news page
  $('.flash-alerts-items-wrap').slick({
    arrows: false,
    infinite: true,
    slidesToShow: 6,
    autoplay: true,
    autoplaySpeed: 0,
    cssEase: "linear",
    speed: 6000,
  });

  /* back-to-top button*/
  $('.back-to-top').hide();
  $('.back-to-top').on("click", function (e) {
    e.preventDefault();
    $('html, body').animate({
      scrollTop: 0
    }, 'slow');
  });
  $(window).scroll(function () {
    var scrollheight = 900;
    if ($(window).scrollTop() > scrollheight) {
      $('.back-to-top').fadeIn();

    } else {
      $('.back-to-top').fadeOut();
    }
  });

})(jQuery);